package com.hero.objects.powers;

import java.text.NumberFormat;
import java.util.ArrayList;

import org.jdom.Element;

import com.hero.HeroDesigner;
import com.hero.objects.Adder;
import com.hero.objects.GenericObject;

/**
 * Copyright (c) 2000 - 2005, CompNet Design, Inc. All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, is prohibited unless the following conditions are met: 1.
 * Express written consent of CompNet Design, Inc. is obtained by the developer.
 * 2. Redistributions must retain this copyright notice. THIS SOFTWARE IS
 * PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * @author CompNet Design, Inc.
 * @version $Revision$
 */

public class Absorption extends Power {

	private static String xmlID = "ABSORPTION";

	public Absorption(Element root) {
		super(root, Absorption.xmlID);
	}

	/**
	 * Vary this method by Power...some will be 1d6 +1, 1 1/2d6, etc....some
	 * will be 1d6, 2d6, etc.. ...some will be 1d6, 1 1/2d6, etc....
	 * 
	 * @return The display for the damage (if any)
	 */
	public String getDamageDisplay() {
		if (display.toUpperCase().indexOf("[LVL]") >= 0) {
			return "";
		}
		if (HeroDesigner.getActiveTemplate().is6E()) {
			return getLevels()+" BODY";
		} else {
			if ((getLevelValue() == 0) || (getLevelCost() == 0)) {
				return "";
			}
			String ret = "" + getLevels() + "d6";
			int additional = 0;
			for (Adder ad : getAssignedAdders()) {
				if (ad.getXMLID().equals("PLUSONEPIP")) {
					ad.setDisplayInString(false);
					if (getLevels() > 0) {
						ret = getLevels() + "d6+1";
					} else {
						ret = "1 point";
					}
					additional += 1;
				}
				if (ad.getXMLID().equals("PLUSONEHALFDIE")) {
					ad.setDisplayInString(false);
					ret = getLevels() + " 1/2d6";
					additional += 1;
				}
				if (ad.getXMLID().equals("MINUSONEPIP")) {
					ad.setDisplayInString(false);
					ret = "" + (getLevels() + 1);
					ret = getLevels() + 1 + "d6-1";
					additional += 1;
				}
			}
			if (useStandardEffect()) {
				ret += " (standard effect: " + (getLevels() * 3 + additional)
						+ " point" + (getLevels() > 0 ? "s" : "") + ")";
			}
			return ret;
		}
	}

	@Override
	public String getColumn2Output() {
		String ret = getAlias() + " " + getDamageDisplay();
		if (getName().trim().length() > 0) {
			ret = "<i>" + getName() + ":</i>  " + ret;
		}
		if ((getInput() != null) && (getInput().trim().length() > 0)) {
			ret += "  (";
			if (getSelectedOption() != null) {
				ret += getSelectedOption().getAlias() + ", ";
			}
			ret += getInput() + ")";
		} else if (getSelectedOption() != null) {
			ret += "  (";
			ret += getSelectedOption().getAlias() + ")";
		}
		int max = getLevels() * 6;
		if (GenericObject.findObjectByID(getAssignedAdders(), "PLUSONEHALFDIE") != null) {
			max += 3;
		}
		if (GenericObject.findObjectByID(getAssignedAdders(), "MINUSONEPIP") != null) {
			max += 3;
		}
		if (GenericObject.findObjectByID(getAssignedAdders(), "PLUSONEPIP") != null) {
			max += 1;
		}
		ArrayList<Adder> tempAdders = new ArrayList<Adder>();
		boolean increasedMax = false;
		for (Adder ad : getAssignedAdders()) {
			if (ad.getXMLID().equals("INCREASEDMAX")) {
				max += ad.getLevels();
				increasedMax = true;
			} else {
				tempAdders.add(ad);
			}
		}
		if (increasedMax) {
			ret += ", Can Absorb Maximum Of "
					+ NumberFormat.getIntegerInstance().format(max)
					+ " Points'";
			if (getSelectedOption() != null) {
				ret += " Worth Of ";
				String type = getSelectedOption().getAlias();
				type = type.substring(0, 1).toUpperCase()
						+ type.substring(1, type.length());
				type += " Damage";
				ret += type;
			}
		}
		ArrayList<Adder> origAdders = assignedAdders;
		setAssignedAdders(tempAdders);
		String adderString = getAdderString();
		setAssignedAdders(origAdders);
		if (adderString.trim().length() > 0) {
			ret += ", " + adderString;
		}
		ret += getModifierString();
		if ((getEndUsage() > 0)
				&& (GenericObject.findObjectByID(HeroDesigner.getActiveHero()
						.getPowers(), "ENDURANCERESERVE") != null)
				&& (GenericObject.findObjectByID(getAllAssignedModifiers(),
						"ENDRESERVEOREND") == null)
				&& !HeroDesigner.getInstance().getPrefs().useWG()) {
			if (getUseENDReserve()) {
				ret += " (uses END Reserve)";
			} else {
				ret += " (uses Personal END)";
			}
		}
		return ret;
	}
}